
schedule("desktopIconIaudio", initIaudio);

var iconWidth = 48;




function initIaudio()
{
	var desktopIconIaudio = document.getElementById("desktopIconIaudio");
	var finderDrag = document.getElementById("finderDrag");
	var finderClose = document.getElementById("finderClose");
	
	attachEventListener(desktopIconIaudio, "dblclick", dblclickDesktopIconIaudio, false);
	attachEventListener(finderDrag, "mousedown", mousedownFinderDrag, false);
	
	attachEventListener(finderClose, "click", clickFinderClose, false);
	
	return true;
}




function dblclickDesktopIconIaudio()
{
	var finder = document.getElementById("finder");
	
	finder.style.display = "block";
	
	return true;
}




function mousedownFinderDrag(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	this.originalX = event.clientX;
	this.originalY = event.clientY;
	
	attachEventListener(document, "mousemove", mousemoveFinderDrag, false);
	attachEventListener(document, "mouseup", mouseupFinderDrag, false);
	
	return true;
}




function mouseupFinderDrag()
{
	detachEventListener(document, "mousemove", mousemoveFinderDrag, false);
	
	return true;
}




function mousemoveFinderDrag(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	var finder = document.getElementById("finder");
	var finderDrag = document.getElementById("finderDrag");
	var currLeft = parseInt(retrieveComputedStyle(finder, "left"));
	var currTop = parseInt(retrieveComputedStyle(finder, "top"));
	
	finder.style.left = currLeft + (event.clientX - finderDrag.originalX) + "px";
	finder.style.top = currTop + (event.clientY - finderDrag.originalY) + "px";
	
	finderDrag.originalX = event.clientX;
	finderDrag.originalY = event.clientY;
	
	return true;
}




function clickFinderClose()
{
	var finder = document.getElementById("finder");
	
	finder.style.display = "none";
	
	return true;
}




